
#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.DAL.UnitTests
{

	
	

	[TestFixture]
	public class DAL_DiscardOrQuarantineBloodUnit : BaseTest 
	{
		private DataTable _dtBloodUnit;
		private System.Guid _cannedCommentGuid = System.Guid.Empty;

		[SetUp]
		protected void SetUp() 
		{				
			this.BaseSetUp();

			if (this.RefreshData)
			{
				this._dtBloodUnit = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM vw_BloodShipAllCurrent JOIN BloodUnitFinance ON vw_BloodShipAllCurrent.BloodUnitGuid = BloodUnitFinance.BloodUnitGuid WHERE UnitStatusCode = 'A' AND DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'", true);
								
				this._cannedCommentGuid = DataCreator.GetRecordGuid("SELECT TOP 1 * FROM CannedComment WHERE RecordStatusCode = 'A' AND DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'");

				this.RefreshData = false;
			}
		}

		[Test]
		public void UpdateQuarantineStatus_Pass()
		{
			this.RefreshData = true;

			System.Guid unitGuid = (System.Guid)this._dtBloodUnit.Rows[0][TABLES.BloodUnitStatus.BloodUnitGuid];
			DataTable dtBloodUnit = SprocHelper.GetUpdateQuarantineStatusSprocTable(this._cannedCommentGuid);
			DataTable dtWorkload = new DataTable();
			DataTable dtExceptions = new DataTable();

			dtBloodUnit.Rows[0][TABLES.BloodUnitStatus.RowVersion] = this._dtBloodUnit.Rows[0][ARTIFICIAL.UnitStatusRowVersion];
			dtBloodUnit.Rows[0][TABLES.BloodUnitStatus.BloodUnitGuid] = unitGuid;

			DAL.DiscardOrQuarantineBloodUnit.UpdateQuarantineStatus( dtBloodUnit, dtWorkload, dtExceptions, new DataTable(),null );

			// Cleanup the data, if we were successful
			int uCheck = UnitTestUtil.RunSQL("UPDATE BloodUnitStatus SET QuarantineCannedCommentGuid = NULL WHERE BloodUnitGuid = '" + unitGuid.ToString() + "'");

			Assert.AreEqual(true, true, "ReturnValue");
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(Common.RowVersionException))]
		public void UpdateQuarantineStatus_Fail()
		{
			System.Guid unitGuid = (System.Guid)this._dtBloodUnit.Rows[0][TABLES.BloodUnitStatus.BloodUnitGuid];
			DataTable dtBloodUnit = SprocHelper.GetUpdateQuarantineStatusSprocTable(this._cannedCommentGuid);
			DataTable dtWorkload = new DataTable();
			DataTable dtExceptions = new DataTable();

			dtBloodUnit.Rows[0][TABLES.BloodUnitStatus.BloodUnitGuid] = unitGuid;

			DAL.DiscardOrQuarantineBloodUnit.UpdateQuarantineStatus( dtBloodUnit, dtWorkload, dtExceptions, new DataTable(),null );
		}


		[Test]
		public void UpdateDiscardStatus_Pass()
		{
			this.RefreshData = true;

			System.Guid unitGuid = (System.Guid)this._dtBloodUnit.Rows[0][TABLES.BloodUnitFinance.BloodUnitGuid];
			DataSet data = SprocHelper.GetUpdateDiscardStatusSprocTables(this._cannedCommentGuid);
			DataTable dtFinance = data.Tables[0].Copy();
			DataTable dtDiscard = data.Tables[1].Copy();
			DataTable dtWorkload = new DataTable();
			DataTable dtExceptions = new DataTable();

			dtFinance.Rows[0][TABLES.BloodUnitFinance.BloodUnitFinanceGuid] = this._dtBloodUnit.Rows[0][TABLES.BloodUnitFinance.BloodUnitFinanceGuid];
			DataRow rowVersionDr = UnitTestUtil.RunSQLGetDataRow("SELECT RowVersion FROM BloodUnitFinance WHERE BloodUnitFinanceGuid = '" + this._dtBloodUnit.Rows[0][TABLES.BloodUnitFinance.BloodUnitFinanceGuid] + "'");
			dtFinance.Rows[0][TABLES.BloodUnitFinance.RowVersion] = rowVersionDr[TABLES.BloodUnitFinance.RowVersion];

			dtDiscard.Rows[0][TABLES.BloodUnitStatus.BloodUnitStatusGuid] = this._dtBloodUnit.Rows[0][TABLES.BloodUnitStatus.BloodUnitStatusGuid];
			dtDiscard.Rows[0][TABLES.BloodUnitStatus.RowVersion] = this._dtBloodUnit.Rows[0][ARTIFICIAL.UnitStatusRowVersion];

			DAL.DiscardOrQuarantineBloodUnit.UpdateDiscardStatus(dtFinance, dtDiscard, dtWorkload, dtExceptions,null);

			//Cleanup the data, if we were successful
			int uCheck = UnitTestUtil.RunSQL("UPDATE BloodUnitStatus SET DiscardCannedCommentGuid = NULL WHERE BloodUnitGuid = '" + unitGuid.ToString() + "'");

			Assert.AreEqual(true, true, "ReturnValue");
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(Common.RowVersionException))]
		public void UpdateDiscardStatus_Fail()
		{
			DataSet data = SprocHelper.GetUpdateDiscardStatusSprocTables(this._cannedCommentGuid);
			DataTable dtFinance = data.Tables[0].Copy();
			DataTable dtDiscard = data.Tables[1].Copy();
			DataTable dtWorkload = new DataTable();
			DataTable dtExceptions = new DataTable();
			//
			DAL.DiscardOrQuarantineBloodUnit.UpdateDiscardStatus(dtFinance, dtDiscard, dtWorkload, dtExceptions,null);
		}

		[Test]
		public void GetDiscardOrQuarantineData_Pass()
		{
			DataRow dr = DAL.DiscardOrQuarantineBloodUnit.GetDiscardOrQuarantineData((System.Guid)this._dtBloodUnit.Rows[0][TABLES.BloodUnit.BloodUnitGuid]);

			Assert.AreEqual(10, dr.Table.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dr.Table.Columns.Contains(TABLES.BloodUnitFinance.ReturnCreditAmount), TABLES.BloodUnitFinance.ReturnCreditAmount);
			Assert.AreEqual(true, dr.Table.Columns.Contains(TABLES.BloodUnitMedia.DirectedPatientGuid), TABLES.BloodUnitMedia.DirectedPatientGuid);
			Assert.AreEqual(true, dr.Table.Columns.Contains(TABLES.BloodUnitMedia.UnitExpirationDate), TABLES.BloodUnitMedia.UnitExpirationDate);
			Assert.AreEqual(true, dr.Table.Columns.Contains(TABLES.Patient.PatientFirstName), TABLES.Patient.PatientFirstName);
			Assert.AreEqual(true, dr.Table.Columns.Contains(TABLES.Patient.PatientLastName), TABLES.Patient.PatientLastName);
			Assert.AreEqual(true, dr.Table.Columns.Contains(TABLES.BloodUnitStatusCodeCurrent.UnitStatusCode), TABLES.BloodUnitStatusCodeCurrent.UnitStatusCode);
			Assert.AreEqual(true, dr.Table.Columns.Contains(TABLES.BloodUnitStatus.QuarantineIndicator), TABLES.BloodUnitStatus.QuarantineIndicator);
			Assert.AreEqual(true, dr.Table.Columns.Contains(TABLES.BloodProduct.ProductTypeCode), TABLES.BloodProduct.ProductTypeCode);
			Assert.AreEqual(true, dr.Table.Columns.Contains(TABLES.BloodUnitStatus.LastUpdateDate), TABLES.BloodUnitStatus.LastUpdateDate);
			Assert.AreEqual(true, dr.Table.Columns.Contains(ARTIFICIAL.UnitStatusRowVersion), ARTIFICIAL.UnitStatusRowVersion);
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(RowNotInTableException))]
		public void GetDiscardOrQuarantineData_Fail()
		{
			DataRow dr = DAL.DiscardOrQuarantineBloodUnit.GetDiscardOrQuarantineData(System.Guid.NewGuid());
		}

		[Test]
		public void GetStatusDetails_Pass()
		{
			DataTable dtTest = DAL.DiscardOrQuarantineBloodUnit.GetStatusDetails();
			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
			Assert.AreEqual(2, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.UnitStatus.UnitStatusCode), TABLES.UnitStatus.UnitStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.UnitStatus.UnitStatusText), TABLES.UnitStatus.UnitStatusText);
		}
		

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetStatusDetails_Fail()
		{
		}

		[Test]
		public void GetDiscardOrQuarantineUnits_Pass()
		{
			DataTable dtTest = DAL.DiscardOrQuarantineBloodUnit.GetDiscardOrQuarantineUnits();
			
			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
			Assert.AreEqual(43, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.BloodUnitGuid), TABLES.BloodUnit.BloodUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.EyeReadableUnitId), TABLES.BloodUnit.EyeReadableUnitId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.DirectedPatientGuid), TABLES.BloodUnitMedia.DirectedPatientGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitProductCode), TABLES.BloodUnit.UnitProductCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.RhFactorCode), TABLES.BloodUnitMedia.RhFactorCode);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.UnitExpirationDate), TABLES.BloodUnitMedia.UnitExpirationDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DonationTypeId), TABLES.BloodUnit.DonationTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitInDate), TABLES.BloodUnit.UnitInDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DivisionCode), TABLES.BloodUnit.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.BloodTypeCode), TABLES.BloodUnitMedia.BloodTypeCode);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitFdaRegistrationNumber), TABLES.BloodUnit.UnitFdaRegistrationNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.LabelUnitId), TABLES.BloodUnit.LabelUnitId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductTypeCode), TABLES.BloodProduct.ProductTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductName), TABLES.BloodProduct.ProductName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductShortName), TABLES.BloodProduct.ProductShortName);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.BiohazardousWarningIndicator), TABLES.BloodUnitStatus.BiohazardousWarningIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.DonationType.DonationTypeText), TABLES.DonationType.DonationTypeText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductType.ProductTypeName), TABLES.ProductType.ProductTypeName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RhFactor.RhFactorText), TABLES.RhFactor.RhFactorText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Facility.FacilityName), TABLES.Facility.FacilityName);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientFirstName), TABLES.Patient.PatientFirstName);			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientMiddleName), TABLES.Patient.PatientMiddleName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientLastName), TABLES.Patient.PatientLastName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.MaximumStorageTime), TABLES.BloodProduct.MaximumStorageTime);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.VistaPatientId), TABLES.Patient.VistaPatientId);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientSsn), TABLES.Patient.PatientSsn);			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.DisplayVistaPatientId), TABLES.Patient.DisplayVistaPatientId);						
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.UnitStatusComments), TABLES.BloodUnitStatus.UnitStatusComments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.DiscardCannedCommentGuid), TABLES.BloodUnitStatus.DiscardCannedCommentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatusCodeCurrent.UnitStatusCode), TABLES.BloodUnitStatusCodeCurrent.UnitStatusCode);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.UnitStatus.UnitStatusText), TABLES.UnitStatus.UnitStatusText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.QuarantineIndicator), TABLES.BloodUnitStatus.QuarantineIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.TestingStatusId), TABLES.BloodUnitMedia.TestingStatusId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.OriginalVolume), TABLES.BloodUnit.OriginalVolume);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.LabelTypeCode), TABLES.BloodUnit.LabelTypeCode);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.RowVersion), TABLES.BloodUnit.RowVersion);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.Comments), TABLES.BloodUnitMedia.Comments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitShipment.IncomingShipmentGuid), TABLES.BloodUnitShipment.IncomingShipmentGuid);
			Assert.AreEqual(true , dtTest.Columns.Contains(ARTIFICIAL.ABORh), ARTIFICIAL.ABORh);
			Assert.AreEqual(true , dtTest.Columns.Contains(TABLES.BloodUnit.UnitDivisionId), TABLES.BloodUnit.UnitDivisionId);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Shipment.ShipmentDate), TABLES.Shipment.ShipmentDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.PresumedTransfusedIndicator), TABLES.BloodUnitStatus.PresumedTransfusedIndicator);
			Assert.AreEqual(true , dtTest.Columns.Contains(ARTIFICIAL.FullProductCode), ARTIFICIAL.FullProductCode);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetDiscardOrQuarantineUnits_Fail()
		{
		}


		[Test]
		public void GetAboRhForConsistencyCheck_Pass()
		{
			System.Guid unitGuid = DataCreator.GetRecordGuid("SELECT TOP 1 BloodUnitGuid FROM BloodUnit WHERE RecordStatusCode = 'A' AND DivisionCode = '" + this.TestDivisionCode + "' AND BloodUnitGuid IN (SELECT DISTINCT BloodUnitGuid FROM BloodUnitTest WHERE BloodTestTypeId IN (18, 21, 25, 65, 68, 105, 106, 118, 121, 125) AND RecordStatusCode = 'A')");

			DataSet dsTest = DAL.DiscardOrQuarantineBloodUnit.GetAboRhForConsistencyCheck(unitGuid);

			Assert.AreEqual(2, dsTest.Tables.Count, "Tables.Count");

			Assert.AreEqual(2, dsTest.Tables[0].Columns.Count, "[0] - Columns.Count");
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.BloodType.BloodTypeCode), "[0] -" + TABLES.BloodType.BloodTypeCode);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.RhFactor.RhFactorText), "[0] -" + TABLES.RhFactor.RhFactorText);

			Assert.AreEqual(3, dsTest.Tables[1].Columns.Count, "[1] - Columns.Count");
			Assert.AreEqual(true, dsTest.Tables[1].Columns.Contains(TABLES.BloodTestType.BloodTestName), "[1] -" + TABLES.BloodTestType.BloodTestName);
			Assert.AreEqual(true, dsTest.Tables[1].Columns.Contains(TABLES.TestResult.TestResultText), "[1] -" + TABLES.TestResult.TestResultText);
			Assert.AreEqual(true, dsTest.Tables[1].Columns.Contains(TABLES.TestResult.LastUpdateDate), "[1] -" + TABLES.TestResult.LastUpdateDate);
		}


		[Test]
		public void GetAboRhForConsistencyCheck_Fail()
		{
			//Empty BloodUnitGuid
			try
			{
				DAL.DiscardOrQuarantineBloodUnit.GetAboRhForConsistencyCheck(System.Guid.Empty);
				Assert.Fail("Guid.Empty failed");
			}
			catch(ArgumentException)
			{
				Assert.IsTrue(true, "Empty Guid");
			}
			
			//New BloodUnitGuid
			try
			{
				DAL.DiscardOrQuarantineBloodUnit.GetAboRhForConsistencyCheck(System.Guid.NewGuid());
				Assert.Fail("Guid.NewGuid failed");
			}
            catch (Common.DataAccessLayerException)
			{
				Assert.IsTrue(true, "New Guid");
			}
			
		}

		
		[Test]
		public void GetAntigenTypingForConsistencyCheck_Pass()
		{
			System.Guid unitGuid = DataCreator.GetRecordGuid("SELECT TOP 1 BloodUnitGuid FROM BloodUnit WHERE RecordStatusCode = 'A' AND DivisionCode = '" + this.TestDivisionCode + "'");

			DataSet dsTest = DAL.DiscardOrQuarantineBloodUnit.GetAntigenTypingForConsistencyCheck(unitGuid);

			Assert.AreEqual(2, dsTest.Tables.Count, "Tables.Count");
			
			Assert.AreEqual(1, dsTest.Tables[0].Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.AntigenTest.AntigenTypeId), TABLES.AntigenTest.AntigenTypeId);

			Assert.AreEqual(4, dsTest.Tables[1].Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dsTest.Tables[1].Columns.Contains(TABLES.AntigenType.AntigenTypeId), TABLES.AntigenType.AntigenTypeId);
			Assert.AreEqual(true, dsTest.Tables[1].Columns.Contains(TABLES.AntigenType.AntigenTypeName), TABLES.AntigenType.AntigenTypeName);
			Assert.AreEqual(true , dsTest.Tables[1].Columns.Contains(TABLES.BloodUnitAntigen.Positive), TABLES.BloodUnitAntigen.Positive);
			Assert.AreEqual(true , dsTest.Tables[1].Columns.Contains(TABLES.BloodUnitAntigen.LastUpdateDate), TABLES.BloodUnitAntigen.LastUpdateDate);
		}


		[Test]
		[ExpectedException(typeof(ArgumentException))]
		public void GetAntigenTypingForConsistencyCheck_Fail()
		{
			DAL.DiscardOrQuarantineBloodUnit.GetAntigenTypingForConsistencyCheck(System.Guid.Empty);
		}


	}
}
#endif


